#!/bin/sh

MASTER_PAGE_SB_DEPLOY_DONE_RESULT_MSG=""
MASTER_PAGE_SB_DEPLOY_DONE_RESULT_OK=0
MASTER_PAGE_SB_DEPLOY_DONE_RESULT_ERROR=1

MASTER_PAGE_SB_DEPLOY_DONE_RESULT_CODE=${MASTER_PAGE_SB_DEPLOY_DONE_RESULT_ERROR}
MASTER_PAGE_SB_DEPLOY_DONE_RESULT_ROLLING=0

master_page_sb_deploy_done() {
     debug_print "in function '${FUNCNAME[0]}'"
    
    
    ########################################
    # cleanup
    ########################################
    debug_print "cleanup deployment ..."
    php $CONS_BACKEND cleanup_deployment >/dev/null 2>&1
    local ret="${?}"
    if [ "${ret}" -ne 0 ]; then
        debug_print "fail to cleanup deployment: ${ret}"
        warning "${ERROR_STRING_CLEANUP_DEPLOYMENT}"
    fi


    ########################################
    # update deploy status to "1"
    ########################################
    RT_DEPLOY_STATUS=1    
    utility_save_deployed_conf "${RT_DEPLOY_STATUS}"
    if [ "${?}" -ne 0 ]; then
        debug_print "fail to modify \"configuration.cli.deployed\" to 1"
        error "${MASTER_PAGE_SB_DEPLOY_DONE_ERROR_SAVE_CONFIGURATION}"
        MASTER_PAGE_SB_DEPLOY_DONE_RESULT_ROLLING=0
        MASTER_PAGE_SB_DEPLOY_DONE_RESULT_CODE=${MASTER_PAGE_SB_DEPLOY_DONE_RESULT_ERROR}
        return
    fi
    

    ########################################
    # notify eemaild that sandboxes reconfig is done
    #     - backups samples will be resubmitted by eemaild
    ########################################
    utility_save_reconfig_sb_conf 0
    if [ "${?}" -ne 0 ]; then
        debug_print "fail to modify \"configuration.extract_email.reconfigure_sanbox\" to 0"
        error "${MASTER_PAGE_SB_DEPLOY_DONE_ERROR_SAVE_CONFIGURATION}"
        MASTER_PAGE_SB_DEPLOY_DONE_RESULT_ROLLING=0
        MASTER_PAGE_SB_DEPLOY_DONE_RESULT_CODE=${MASTER_PAGE_SB_DEPLOY_DONE_RESULT_ERROR}
        return
    fi
    

    ########################################
    # composing result message
    ########################################
    [ -z "${RT_MASTER_MODE}" ] && RT_MASTER_MODE="${conf_cli_master}"

    local message
    
    # when NewSBGroup is empty
    if [ ! -s "${NEW_SB_GROUP_INFO_ESXI_FILE}" ]; then
        message="${MASTER_PAGE_SB_DEPLOY_DONE_PAGE_SUBTITLE_REMOVE_ALL_SB}"
    
    # when running in master mode
    elif [ "${RT_MASTER_MODE}" -eq 1 ]; then
        message=`printf "${MASTER_PAGE_SB_DEPLOY_DONE_PAGE_SUBTITLE}" "${RT_SB_NUMBER}"`
    
    # when running in cluster mode
    else
        message=`printf "${MASTER_PAGE_SB_DEPLOY_DONE_PAGE_SUBTITLE}" "${RT_SB_NUMBER}"`
    fi

    # bring out TextUI
    tp_msg_ok \
        "${MASTER_PAGE_SB_DEPLOY_DONE_TITLE}" \
        "${message}" \
        "${MASTER_PAGE_SB_DEPLOY_DONE_OK_LABEL}" 

    MASTER_PAGE_SB_DEPLOY_DONE_RESULT_ROLLING=1
    MASTER_PAGE_SB_DEPLOY_DONE_RESULT_CODE=${MASTER_PAGE_SB_DEPLOY_DONE_RESULT_OK}
}